<?php

require_once '../model/database.php';
require_once '../model/vendor_model.php';
require_once 'header.php';

echo "<nav><a href='../index.php'>Home</a> | <a href='manage_vendors.php'>Manage Vendors</a> | <a href='product_info.php'>Product Info</a></nav>";

if (isset($_GET['id'])) {
    $vend_id = $_GET['id'];
    $vendor = get_vendor_by_id($conn, $vend_id);

    if ($vendor) {
        echo "<h1>Vendor Details</h1>";

        // Mapping field names to human-readable labels
        $labels = [
            'vend_id' => 'Vendor ID',
            'vend_name' => 'Vendor Name',
            'vend_address' => 'Vendor Address',
            'vend_city' => 'Vendor City',
            'vend_state' => 'Vendor State',
            'vend_zip' => 'Vendor Zip',
            'vend_country' => 'Vendor Country'
        ];

        echo "<table border='1' cellpadding='5'>";
        
        // Table header (across the top)
        echo "<thead><tr>";
        foreach ($labels as $label) {
            echo "<th>$label</th>";
        }
        echo "</tr></thead>";

        // Table body (product details)
        echo "<tbody><tr>";
        foreach ($vendor as $key => $value) {
            // Use the label from the mapping array or the key itself if not found in the labels array
            $label = isset($labels[$key]) ? $labels[$key] : ucfirst(str_replace('_', ' ', $key));
            echo "<td>" . htmlspecialchars($value) . "</td>";
        }
        echo "</tr></tbody>";
        
        echo "</table>";        
    } else {
        echo "<p>Vendor not found.</p>";
    }
} else {
    echo "<p>Vendor ID not provided.</p>";
}

require_once 'footer.php';

?>
